﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Collections;
using System.Threading;


/* using Monitor.Wait() and Monitor.Pulse() 
   wait queue
   ready queue */
namespace Lessons
{
    public partial class MainForm : Form
    {
        public MainForm()
        {
            InitializeComponent();
            synContext = WindowsFormsSynchronizationContext.Current;
            primaryThread = Thread.CurrentThread;
        }

        object syncRoot = new object();
        SynchronizationContext synContext;
        Thread primaryThread = null;
        Thread t = null;


        bool IsPrimaryThread()
        {
            return primaryThread == Thread.CurrentThread;
        }

        void Send(string Text)
        {
            string S = "";

            if (IsPrimaryThread())
                S = "MAIN   : " + Text;
            else
                S = "SECOND : " + Text;
 
            synContext.Send(SynchronizedMethod, S);
        }

 
        void ThreadProc()
        {
            Send("Enter");

            lock (syncRoot)
            {
                if (!IsPrimaryThread())
                {
                    Send("waiting....");

                    Monitor.Wait(syncRoot); // this releases the lock, letting the other threads acquire it

                    Send("waked up");
                }
                else
                {
                    Send("waking up the second thread");
                    Monitor.Pulse(syncRoot);
                }
                
            }

            Send("Exit");
        }

 

        void SynchronizedMethod(object state)
        {
            textBox1.Text += state.ToString() + Environment.NewLine;
        }

        private void button1_Click(object sender, EventArgs e)
        {
            if ((t == null) || (!t.IsAlive))
            {
                t = new Thread(ThreadProc);
                t.Start();

                Thread.Sleep(2000); // lets be sure the secondary thread starts first

                ThreadProc();
            }
        }

        private void MainForm_FormClosing(object sender, FormClosingEventArgs e)
        {
            e.Cancel = (t != null) && (t.IsAlive);

            if (e.Cancel)
                MessageBox.Show("Please wait! A thread is still executed...");
        }
    }
}
